<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$this->load->helper('form');
?>

				<h1>Events</h1>
				<div class="column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<?php echo $tabs;?>
					<div class="tab-content">
						<p>This table lists the events.</p>
						<?PHP echo form_open('/reports/events',array('id'=>'reports_form','onsubmit'=>"javascript:submitPaginationForm('', 1, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form">							
								<tr class="form_row">
									<td>Success:</td>
									<td>
										<select class="fill_row" id="successful" name="successful" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="1" <?php if(isset($form_data['successful']) && '1'==$form_data['successful']){echo "selected";}?>>TRUE</option>
											<option value="0" <?php if(isset($form_data['successful']) && '0'==$form_data['successful']){echo "selected";}?>>FALSE</option>
											<option value="2" <?php if(isset($form_data['successful']) && '2'==$form_data['successful']){echo "selected";}?>>UNAUTH</option>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>ID:</td>
									<td>
										<p class="hidden_context" style="display:none;" id="event_id_help">Table ID of event</p>
										<input class="ttFocus" aria-describedby="event_id_help" title="Table ID of event" id="event_id" name="event_id" type="text" value="<?php if(isset($form_data['event_id'])) { echo htmlentities($form_data['event_id']); } ?>" onkeydown="if(event.keyCode == 13){$('#event_id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for ID</label>
										<select id="event_id_type" name="event_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['event_id_type']) && $key == $form_data['event_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Action:</td>
									<td>
										<p class="hidden_context" style="display:none;" id="action_help">Action executed</p>
										<input class="ttFocus" aria-describedby="action_help" title="Action executed" id="action" name="action" type="text" value="<?php if(isset($form_data['action'])) { echo htmlentities($form_data['action']); } ?>" onkeydown="if(event.keyCode == 13){$('#action').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for Action</label>
										<select id="action_type" name="action_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['action_type']) && $key == $form_data['action_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Target:</td>
									<td>
										<p class="hidden_context" style="display:none;" id="target_user_help">Target of the action executed</p>
										<input class="ttFocus" aria-describedby="target_user_help" title="Target of the action executed" id="target_user" name="target_user" type="text" value="<?php if(isset($form_data['target_user'])) { echo htmlentities($form_data['target_user']); } ?>" onkeydown="if(event.keyCode == 13){$('#target_user').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for Target</label>
										<select id="target_user_type" name="target_user_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['target_user_type']) && $key == $form_data['target_user_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Target Type:</td>
									<td>
										<select class="fill_row" id="target_type" name="target_type" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="3" <?php if(isset($form_data['target_type']) && 3==$form_data['target_type']){echo "selected";}?>>User</option>
											<option value="2" <?php if(isset($form_data['target_type']) && 2==$form_data['target_type']){echo "selected";}?>>Application</option>
											<option value="1" <?php if(isset($form_data['target_type']) && 1==$form_data['target_type']){echo "selected";}?>>App Request</option>
											<option value="4" <?php if(isset($form_data['target_type']) && 4==$form_data['target_type']){echo "selected";}?>>User Request</option>
											<option value="6" <?php if(isset($form_data['target_type']) && 6==$form_data['target_type']){echo "selected";}?>>Group</option>
											<option value="8" <?php if(isset($form_data['target_type']) && 8==$form_data['target_type']){echo "selected";}?>>Search</option>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Actor:</td>
									<td>
										<p class="hidden_context" style="display:none;" id="acting_user_help">User or Application executing action</p>
										<input class="ttFocus" aria-describedby="acting_user_help" title="User or Application executing action" id="acting_user" name="acting_user" type="text" value="<?php if(isset($form_data['acting_user'])) { echo htmlentities($form_data['acting_user']); } ?>" onkeydown="if(event.keyCode == 13){$('#acting_user').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for Acting</label>
										<select id="acting_user_type" name="acting_user_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['acting_user_type']) && $key == $form_data['acting_user_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Acting Type:</td>
									<td>
										<select class="fill_row" id="acting_type" name="acting_type" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="3" <?php if(isset($form_data['acting_type']) && 3==$form_data['acting_type']){echo "selected";}?>>User</option>
											<option value="2" <?php if(isset($form_data['acting_type']) && 2==$form_data['acting_type']){echo "selected";}?>>Application</option>
											<option value="1" <?php if(isset($form_data['acting_type']) && 1==$form_data['acting_type']){echo "selected";}?>>App Request</option>
											<option value="4" <?php if(isset($form_data['acting_type']) && 4==$form_data['acting_type']){echo "selected";}?>>User Request</option>
										</select>
									</td>									
								</tr>								
								<tr class="form_row">
									<td>Start Date:</td>
									<td><input type="text" id="start_date" name="start_date" class="date" value="<?php if(isset($form_data['start_date'])) { echo htmlentities($form_data['start_date']); } ?>"onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
									<td>
									</td>
									<td>End Date:</td>
									<td><input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo htmlentities($form_data['end_date']); } ?>"onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt", timeSuffix: ' '+timezone_abbr});</script>
							</table>
							<?PHP
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'export_pdf' => '0',
									'print_page' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter" ></input>
								<!-- <input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>-->
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<div id="date_error_message" class="message_error" style="display: none;"></div>
							<?php if(sizeof($event_list) == 0) { ?>
								<div class="message">There are currently no events tracked in the system.</div>
							<?php }else{ 
								if(!empty($form_data['date_warning_message'])) { ?>
									<div class="message"><?php echo $form_data['date_warning_message']; ?></div>
								<?PHP } ?>	
								<?php if(sizeof($event_list) > 0) { ?>
									<div class="pagination">
										<?php echo $form_data['pages']->display_result_num();?>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
										<?php echo $form_data['pages']->display_items_per_page();?>
										<div style="float:right; position:relative">
											<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
												<a href="#" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } 
											else { ?>
												<a href="#" onclick="if ( confirm('You are going to export <?php echo $form_data['pages']->items_total; ?> records and this will take a few minutes. Are you sure you want to proceed?')){ $('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');}"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } ?>
											<a id="export_pdf" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
											<a href="#"  onclick="$('#print_page').attr('value','1');$('#reports_form').submit();$('#print_page').attr('value','0');"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
											<label class="hidden_context">Page Selector</label>
											<input id="page_select" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
											<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
										</div>
									</div>
								<?php } ?>
							<?php }?> 
						<?PHP echo form_close(); ?>
						<?PHP echo form_open('/reports/events',array('id'=>'clear_form')); echo form_close();
							if(sizeof($event_list) > 0) {
							  $this->load->view('api/reports/result_tables/result_events');
						?>
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page();?>
								<div style="float:right; position:relative">
									<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
										<a href="#" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } 
									else { ?>
										<a href="#" onclick="if ( confirm('You are going to export <?php echo $form_data['pages']->items_total; ?> records and this will take a few minutes. Are you sure you want to proceed?')){ $('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');}"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } ?>
									<a id="export_pdf" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
									<a href="#"  onclick="$('#print_page').attr('value','1');$('#reports_form').submit();$('#print_page').attr('value','0');"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
									<label class="hidden_context">Page Selector</label>
									<input id="page_select" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							<?php }?> 
						</div>
					</div>
				</div>
			</div>
			<?php $this->load->view('api/reports/result_tables/file_downloading_window');?>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>